/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.render.infobar;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.client.render.infobar.DataSourcedElement;
import dev.toma.gunsrpg.common.quests.quest.DisplayInfo;
import dev.toma.gunsrpg.common.quests.quest.Quest;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class QuestInfoElement
extends DataSourcedElement<Quest<?>> {
    private final boolean showObjective;
    private final ITextComponent title;
    private final ITextComponent objective;
    private int width;
    private int height;

    public QuestInfoElement(Quest<?> quest, boolean showObjective) {
        super(quest);
        this.showObjective = showObjective;
        DisplayInfo info = quest.getScheme().getDisplayInfo();
        this.title = new StringTextComponent(info.getName().getString()).func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.BOLD});
        this.objective = info.getInfo();
    }

    @Override
    public void draw(MatrixStack matrix, FontRenderer font, int x, int y, int width, int height) {
        this.calculateWidthAndHeight(font);
        font.func_243248_b(matrix, this.title, (float)x, (float)y, 0xFFFFFF);
        if (this.showObjective) {
            font.func_243248_b(matrix, this.objective, (float)x, (float)(y + 10), 0xFFFFFF);
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    private void calculateWidthAndHeight(FontRenderer font) {
        int width = font.func_238414_a_((ITextProperties)this.title);
        int height = 10;
        if (this.showObjective) {
            width = Math.max(width, font.func_238414_a_((ITextProperties)this.objective));
            height *= 2;
        }
        this.width = width;
        this.height = height;
    }
}

